<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <title>Notifications</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            margin: 20px;
            background-color: #f4f4f4;
        }
        .notification {
            background-color: #fff;
            padding: 15px;
            margin-bottom: 10px;
            border-left: 4px solid #4CAF50;
            border-radius: 4px;
            box-shadow: 0 2px 5px rgba(0,0,0,0.1);
        }
        .notification.unread {
            border-left-color: #2196F3;
            font-weight: bold;
        }
        .notification .message {
            color: #333;
        }
        .notification .time {
            font-size: 0.9em;
            color: #777;
        }
        .mark-read {
            margin-top: 10px;
        }
        .mark-read form {
            display: inline;
        }
        .mark-read button {
            background-color: #2196F3;
            color: white;
            border: none;
            padding: 5px 10px;
            border-radius: 4px;
            cursor: pointer;
        }
        .mark-read button:hover {
            background-color: #1976D2;
        }
        .success {
            color: green;
            margin-top: 10px;
        }
        .error {
            color: red;
            margin-top: 10px;
        }
    </style>
</head>
<body>
    <h1>Notifications</h1>

    @if(session('success'))
        <div class="success">{{ session('success') }}</div>
        @if(session('updatedNotification'))
            <p>Updated Status: {{ session('updatedNotification')->Is_read ? 'Read' : 'Unread' }}</p>
        @endif
    @elseif(session('error'))
        <div class="error">{{ session('error') }}</div>
    @endif

    @if($notifications->isEmpty())
        <p>No notifications available.</p>
    @else
        @foreach($notifications as $notification)
            <div class="notification {{ !$notification->Is_read ? 'unread' : '' }}">
                <div class="message">
                    {{ $notification->Message }}
                    <br><small>User: {{ $notification->user->Email ?? 'N/A' }}</small>
                </div>
                <div class="time">
                    Posted on: {{ $notification->Created_at }}
                </div>
                @if(!$notification->Is_read)
                    <div class="mark-read">
                        <form action="{{ url('/notifications/' . $notification->Notification_id . '/read') }}" method="POST" onsubmit="return confirm('Mark this notification as read?');" data-debug="form-for-{{ $notification->Notification_id }}">
                            @csrf
                            <button type="submit">Mark as Read</button>
                        </form>
                    </div>
                @endif
            </div>
        @endforeach
    @endif
</body>
</html>
